﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.Graphics;

namespace CashierCrisis
{
     public enum CustomerColor
        {
            Red,
            Blue,
            Yellow,
            Green
        }

    public static class CustomerSpriteContent
    {
       

        private static Dictionary<string, Texture2D> sprites = new Dictionary<string, Texture2D>();

        public static void LoadContent(ContentManager content)
        {
            // Man
            LoadSprites(content, "Man");
            //Girl
            LoadSprites(content, "Girl");
        }

        public static Texture2D GetSprite(string name, string mood, CustomerColor color)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("Customer_");
            sb.Append(name);
            sb.Append("_");
            sb.Append(mood);
            sb.Append("_");
            sb.Append(color.ToString());
            return sprites[sb.ToString()];
        }

        private static void LoadSprites(ContentManager content, string name)
        {
            string location = "Sprites//Customers//" + name + "//";

            for (int i = 0; i < 4; i++)
            {
               
                string c = "Customer_" + name + "_Neutral_" + (CustomerColor)i;
                sprites.Add(c, content.Load<Texture2D>(location + c));
            }

            for (int i = 0; i < 4; i++)
            {
                string c = "Customer_" + name + "_Happy_" + (CustomerColor)i;
                sprites.Add(c, content.Load<Texture2D>(location + c));
            }

            for (int i = 0; i < 4; i++)
            {
                string c = "Customer_" + name + "_SuperHappy_" + (CustomerColor)i;
                sprites.Add(c, content.Load<Texture2D>(location + c));
            }

            for (int i = 0; i < 4; i++)
            {
                string c = "Customer_" + name + "_Angry_" + (CustomerColor)i;
                sprites.Add(c, content.Load<Texture2D>(location + c));
            }

            for (int i = 0; i < 4; i++)
            {
                string c = "Customer_" + name + "_SuperAngry_" + (CustomerColor)i;
                sprites.Add(c, content.Load<Texture2D>(location + c));
            }

            for (int i = 0; i < 4; i++)
            {
                string c = "Customer_" + name + "_Puzzled_" + (CustomerColor)i;
                sprites.Add(c, content.Load<Texture2D>(location + c));
            }
        }
    }
}
